/**
* \file: cfgfile_parser.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: authorization level daemon
*
* \author: Rexaline Xavier  /  RexalineInfancia.Xavier@in.bosch.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef ALD_UTIL_CFGFILE_PARSER_H
#define ALD_UTIL_CFGFILE_PARSER_H

#include "ald_types.h"

extern const cfg_item_spec_t log_level_cfg_spec;
extern const cfg_item_spec_t state_path_cfg_spec;
extern const cfg_item_spec_t script_root_cfg_spec;
extern const cfg_item_spec_t sigdb_cfg_spec;
extern const cfg_item_spec_t sigdb_key_cfg_spec;
extern const cfg_item_spec_t challenge_timeout_cfg_spec;
extern const cfg_item_spec_t script_timeout_cfg_spec;
extern const cfg_item_spec_t replay_trigger_cfg_spec;
extern const cfg_item_spec_t level_change_complete_cfg_spec;
extern const cfg_item_spec_t challenge_verify_key_cfg_spec;

extern const cfg_item_spec_t state_val_cfg_spec;
extern const cfg_item_spec_t priv_key_dest_cfg_spec;
extern const cfg_item_spec_t sigdb_privkey_cfg_spec;
extern const cfg_item_spec_t sysroot_cfg_spec;

extern const cfg_item_spec_t levelnum_cfg_spec;
extern const cfg_item_spec_t levelprivkey_cfg_spec;
extern const cfg_item_spec_t serialnum_cfg_spec;
extern const cfg_item_spec_t ecuid_cfg_spec;

extern const cfg_item_spec_t conf_file_cfg_spec;
extern const cfg_item_spec_t help_cfg_spec;


error_code_t cfgfile_parser_parse_config_file(const char *config_file, cfg_item_t *const items[], size_t items_count);

bool cfgfile_parser_is_any_cfg_item_unset(cfg_item_t *const items[], size_t items_count);

#endif
